/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.audio.AudioPlayer;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.AdventureMenuState;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.MenuState;
import com.work4games.gamestate.PlayState;
import com.work4games.gamestate.TimeAttackMenuState;
import com.work4games.gamestate.WorldMenuState;
import com.work4games.handlers.Content;
import com.work4games.tilemap.Background;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class GameStateManager {
    private GameState[] gameStates;
    private static int currentState;
    private static int lastState;
    private Background bg1;
    public Font font;
    public Font pixelFont22;
    public Font pixelFont20;
    public Font pixelFont16;
    public Font pixelFont14;
    public Font ipixelu;
    public static final int NUMGAMESTATES = 5;
    public static final int MENUSTATE = 0;
    public static final int PLAYSTATE = 1;
    public static final int TIMEATTACKMENUSTATE = 2;
    public static final int ADVENTUREMENUSTATE = 3;
    public static final int WORLDMENUSTATE = 4;

    public GameStateManager() throws IOException {
        try {
            this.font = new Font("Arial", 0, 22);
            this.pixelFont22 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(22.0f);
            this.pixelFont20 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(20.0f);
            this.pixelFont16 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(16.0f);
            this.pixelFont14 = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")).deriveFont(14.0f);
            this.ipixelu = Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/I-pixel-u.ttf")).deriveFont(44.0f);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/Minecraft.ttf")));
            ge.registerFont(Font.createFont(0, this.getClass().getResourceAsStream("/Fonts/I-pixel-u.ttf")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        AudioPlayer.init();
        this.bg1 = new Background(Content.CloudBG, 1.0);
        this.bg1.setVector(-0.5, 0.0);
        this.gameStates = new GameState[5];
        currentState = 0;
        this.loadState(currentState);
        PlayerSave.getPlayer();
    }

    private void loadState(int state) {
        if (state == 0) {
            this.gameStates[state] = new MenuState(this);
        }
        if (state == 1) {
            this.gameStates[state] = new PlayState(this);
        }
        if (state == 2) {
            this.gameStates[state] = new TimeAttackMenuState(this);
        }
        if (state == 3) {
            this.gameStates[state] = new AdventureMenuState(this);
        }
        if (state == 4) {
            this.gameStates[state] = new WorldMenuState(this);
        }
    }

    private void unloadState(int state) {
        this.gameStates[state] = null;
    }

    public void setState(int state) {
        this.unloadState(currentState);
        lastState = currentState;
        currentState = state;
        this.loadState(currentState);
        this.gameStates[currentState].init();
    }

    public void update() {
        this.bg1.update();
        if (this.gameStates[currentState] == null) {
            return;
        }
        this.gameStates[currentState].update();
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 640, 480);
        this.bg1.draw(g);
        if (currentState != 1) {
            g.setColor(Color.BLACK);
            g.setFont(this.pixelFont16);
            g.drawString("Player: " + PlayerSave.getPlayerName() + "   Stars: " + PlayerSave.getTotalStars(), 8, 20);
        }
        if (this.gameStates[currentState] == null) {
            return;
        }
        this.gameStates[currentState].draw(g);
        g.setColor(Color.gray);
        g.setFont(this.font);
        if (currentState != 1 && currentState != 4) {
            g.drawString("BETA V.2.0", 5, 470);
        }
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w * 2 - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h * 2 - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public static int getState() {
        return currentState;
    }

    public static int getLastState() {
        return lastState;
    }
}

